-- name: [CS] Rouge the Bat (Monobutt)
-- description: Pissing all by yourself, handsome?\n\n\\#ff7777\\This Pack requires Character Select\nto use as a Library!

--[[
    API Documentation for Character Select can be found below:
    https://github.com/Squishy6094/character-select-coop/blob/main/API-doc.md

    Use this if you're curious on how anything here works >v<
]]

local  FatsoAnims = {
            [CHAR_ANIM_RUNNING] = 'WADDEL',
			[CHAR_ANIM_WALKING] = 'WADDEL'
       }


local E_MODEL_ROUGEMONO_MODEL = smlua_model_util_get_id("rougepear_geo")
local E_MODEL_EMERALD = smlua_model_util_get_id("emeraldshard_geo")

local TEX_ROUGE_ICON = get_texture_info("rouge-icon")
local TEX_EMERALD = get_texture_info("radar-icon")

local rugHealthMeter = {
    label = {
        left = get_texture_info("rougehp-back-left"),
        right = get_texture_info("rughp-back-right"),
    },
    pie = {
        [1] = get_texture_info("creamhp-pie-1"),
        [2] = get_texture_info("creamhp-pie-2"),
        [3] = get_texture_info("creamhp-pie-3"),
        [4] = get_texture_info("creamhp-pie-4"),
        [5] = get_texture_info("creamhp-pie-5"),
        [6] = get_texture_info("creamhp-pie-6"),
        [7] = get_texture_info("creamhp-pie-7"),
        [8] = get_texture_info("creamhp-pie-8"),
    }
}

local TEXT_MOD_NAME = "[CS] Rouge the Bat"

BELLYSND1 = audio_sample_load("tummy1.ogg")
BELLYSND2 = audio_sample_load("tummy2.ogg")
BELLYSND3 = audio_sample_load("tummy3.ogg")
BELLYSND4 = audio_sample_load("tummy4.ogg")
BURPSND1 = audio_sample_load("burp_1.ogg")
BURPSND2 = audio_sample_load("burp_2.ogg")
SLOSHSND1 = audio_sample_load("slosh1.ogg")
SLOSHSND2 = audio_sample_load("slosh2.ogg")

local VOICETABLE_ROUGE = {
    [CHAR_SOUND_ATTACKED] = {'hurt1.ogg', 'hurt2.ogg', 'hurt3.ogg', 'hurt4.ogg', 'hurt5.ogg', 'hurt6.ogg'},
    [CHAR_SOUND_IMA_TIRED] = 'tired.ogg',
	[CHAR_SOUND_UH] = 'huh.ogg',	
	[CHAR_SOUND_UH2] = 'hmm.ogg',
	[CHAR_SOUND_EEUH] = 'eh.ogg',
    [CHAR_SOUND_HRMM] = 'yosh.ogg',
    [CHAR_SOUND_PANTING] = 'pant.ogg',
    [CHAR_SOUND_PANTING_COLD] = 'pant.ogg',
    [CHAR_SOUND_DOH] = {'hurt6.ogg', 'uh1.ogg', 'uh2.ogg'},
    [CHAR_SOUND_DROWNING] = 'drown1.ogg',
    [CHAR_SOUND_DYING] = {'death1.ogg', 'death2.ogg', 'death3.ogg'},
    [CHAR_SOUND_GROUND_POUND_WAH] = 'hipdrop.ogg',
    [CHAR_SOUND_HAHA] = {'socute.ogg', 'howsthis.ogg', 'didyougetthat.ogg'},
    [CHAR_SOUND_HAHA_2] = {'socute.ogg', 'howsthis.ogg', 'didyougetthat.ogg'},
    [CHAR_SOUND_HERE_WE_GO] = {'herewego1.ogg', 'herewego2.ogg', 'herewego3.ogg'},
    [CHAR_SOUND_HOOHOO] = 'yuh.ogg',
    [CHAR_SOUND_MAMA_MIA] = {'mamamia1.ogg', 'mamamia2.ogg', 'mamamia3.ogg', 'mamamia4.ogg', 'mamamia5.ogg', 'shoot.ogg'},
    [CHAR_SOUND_ON_FIRE] = {'burn1.ogg', 'scream1.ogg'},
    [CHAR_SOUND_OOOF] = 'oof.ogg',
    [CHAR_SOUND_OOOF2] = 'oof.ogg',
    [CHAR_SOUND_LETS_A_GO] = 'letsago.ogg',
    [CHAR_SOUND_PUNCH_HOO] = 'kick.ogg',
    [CHAR_SOUND_PUNCH_WAH] = 'punch.ogg',
    [CHAR_SOUND_PUNCH_YAH] = 'punch.ogg',
    [CHAR_SOUND_SO_LONGA_BOWSER] = 'byebye.ogg',
    [CHAR_SOUND_TWIRL_BOUNCE] = 'yeah.ogg',
    [CHAR_SOUND_WAH2] = 'yuh.ogg',
    [CHAR_SOUND_WHOA] = 'woah.ogg',
    [CHAR_SOUND_WAAAOOOW] = 'falling.ogg',
    [CHAR_SOUND_YAHOO] = 'yosh.ogg',
    [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = {'yeah.ogg', 'allright.ogg'},
    [CHAR_SOUND_YAH_WAH_HOO] = {'huh.ogg', 'hmm.ogg'},
    [CHAR_SOUND_YAWNING] = 'pant.ogg',
}


if _G.charSelectExists then
    CT_ROUGE = _G.charSelect.character_add("Rouge the Bat (Monobutt)", {"OH LAWD SHE COMIN'", "", "", "", ""}, "Chaothix", {r = 255, g = 0, b = 255}, E_MODEL_ROUGEMONO_MODEL, CT_WARIO, TEX_ROUGE_ICON, 1.8)
	_G.charSelect.character_add_celebration_star(E_MODEL_ROUGEMONO_MODEL, E_MODEL_EMERALD, TEX_EMERALD)
	
    -- the following must be hooked for each character added
    _G.charSelect.character_add_voice(E_MODEL_ROUGEMONO_MODEL, VOICETABLE_ROUGE)
    hook_event(HOOK_CHARACTER_SOUND, function (m, sound)
        if _G.charSelect.character_get_voice(m) == VOICETABLE_ROUGE then return _G.charSelect.voice.sound(m, sound) end
    end)
    hook_event(HOOK_MARIO_UPDATE, function (m)
        if _G.charSelect.character_get_voice(m) == VOICETABLE_ROUGE then return _G.charSelect.voice.snore(m) end
    end)
else
    djui_popup_create("\\#ffffdc\\\n"..TEXT_MOD_NAME.."\nRequires the Character Select Mod\nto use as a Library!\n\nPlease turn on the Character Select Mod\nand Restart the Room!", 6)
end

_G.charSelect.character_add_health_meter(CT_ROUGE, rugHealthMeter)
_G.charSelect.character_add_animations(E_MODEL_ROUGEMONO_MODEL, FatsoAnims)

local function on_character_select_load()

    _G.charSelect.character_hook_moveset(CT_ROUGE, HOOK_MARIO_UPDATE, rouge_update)
	
end

---Moveset!!---


local animFrame = 1
local stamina = 200

--- @param m MarioState
function rouge_update(m)

local heavyLandActs = {
    [ACT_LONG_JUMP_LAND] = true,
    [ACT_DIVE_SLIDE] = true,
    [ACT_GROUND_POUND_LAND] = true,
    [ACT_TRIPLE_JUMP_LAND] = true,
    [ACT_BACKFLIP_LAND] = true,
    [ACT_AIR_HIT_WALL] = true,
    [ACT_BACKWARD_AIR_KB] = true,
    [ACT_HARD_FORWARD_GROUND_KB] = true,
	[ACT_BUTT_STUCK_IN_GROUND] = true,
}
---@param m MarioState

		if m.action == ACT_GROUND_POUND_LAND and m.actionTimer == 0 and m.prevAction ~= ACT_BUTT_STUCK_IN_GROUND then
		spawn_sync_object(id_bhvBowserShockWave, E_MODEL_BOWSER_WAVE, m.pos.x, m.pos.y, m.pos.z, nil)
    end
	
    if m.action == ACT_TRIPLE_JUMP_LAND and m.actionTimer == 0 then
		spawn_sync_object(id_bhvBowserShockWave, E_MODEL_BOWSER_WAVE, m.pos.x, m.pos.y, m.pos.z, nil)
		m.vel.y = 50
		set_mario_action(m, ACT_GROUND_POUND_LAND, 0)
		play_sound(SOUND_OBJ_BOWSER_WALK, m.marioObj.header.gfx.cameraToObject)
    end
	
	if m.action == ACT_GROUND_POUND or m.action == ACT_DIVE then
		m.peakHeight = m.pos.y
	end

		if m.actionTimer == 0 then 
        local act = m.action & ACT_ID_MASK
        -- forced heavy land sound
        if heavyLandActs[m.action] ~= nil and m.prevAction ~= ACT_BUTT_STUCK_IN_GROUND  then
		    set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE | PARTICLE_HORIZONTAL_STAR), 0)
			set_camera_shake_from_point(SHAKE_POS_LARGE, m.pos.x, m.pos.y, m.pos.z)
			m.squishTimer = 8
			m.marioBodyState.eyeState = MARIO_EYES_CLOSED
			audio_sample_play(SLOSHSND2, gMarioStates[0].pos, 1.0)
            play_sound(SOUND_OBJ_BOWSER_WALK, m.marioObj.header.gfx.cameraToObject)
			m.actionTimer = m.actionTimer + 1
        elseif act >= 0x066 and act <= 0x07A then -- landing actions
            -- heavy land vs mid-heavy land based on fall distance
            if m.peakHeight - m.pos.y >= 800 then
                play_sound(SOUND_OBJ_BOWSER_WALK, m.marioObj.header.gfx.cameraToObject)
			    set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE | PARTICLE_HORIZONTAL_STAR), 0)
				set_camera_shake_from_point(SHAKE_POS_LARGE, m.pos.x, m.pos.y, m.pos.z)
				m.squishTimer = 8
				m.marioBodyState.eyeState = MARIO_EYES_CLOSED
				audio_sample_play(SLOSHSND2, gMarioStates[0].pos, 1.0)
				set_mario_action(m, ACT_BUTT_STUCK_IN_GROUND, 0)
				m.actionTimer = m.actionTimer + 1
            else
                play_sound(SOUND_OBJ_POUNDING1, m.marioObj.header.gfx.cameraToObject)
			    set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE | PARTICLE_HORIZONTAL_STAR), 0)
				set_camera_shake_from_point(SHAKE_POS_MEDIUM, m.pos.x, m.pos.y, m.pos.z)
				m.squishTimer = 2
				audio_sample_play(SLOSHSND1, gMarioStates[0].pos, 1.0)
				m.actionTimer = m.actionTimer + 1
            end
        end
	end


	if m.action == ACT_WALKING then
		stamina = stamina - 1
		set_mario_animation(m, CHAR_ANIM_RUNNING)
		set_anim_to_frame(m, animFrame)
			animFrame = animFrame + 1
        if animFrame >= m.marioObj.header.gfx.animInfo.curAnim.loopEnd then
            animFrame = animFrame - m.marioObj.header.gfx.animInfo.curAnim.loopEnd
			play_sound(SOUND_OBJ_POUNDING1, m.marioObj.header.gfx.cameraToObject)
			set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE), 0)
			set_camera_shake_from_point(SHAKE_POS_SMALL, m.pos.x, m.pos.y, m.pos.z)
        end
        if animFrame == 9 then
			play_sound(SOUND_OBJ_POUNDING1, m.marioObj.header.gfx.cameraToObject)
			set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE), 0)
			set_camera_shake_from_point(SHAKE_POS_SMALL, m.pos.x, m.pos.y, m.pos.z)
        end
		if stamina == 0 then
			play_character_sound(m, CHAR_SOUND_PANTING)
			set_mario_particle_flags(m, (PARTICLE_WATER_SPLASH), 0)
		end
		if stamina == -150 then
			audio_sample_play(BELLYSND1, gMarioStates[0].pos, 1.0)
		end
		if stamina == -800 then
			audio_sample_play(BELLYSND2, gMarioStates[0].pos, 1.0)
			stamina = 200
		end
		if stamina == 25 then
			audio_sample_play(BELLYSND3, gMarioStates[0].pos, 1.0)
		end
		if stamina == 50 then
			audio_sample_play(BURPSND1, gMarioStates[0].pos, 1.0)
		end
		if stamina == -200 then
			audio_sample_play(BURPSND1, gMarioStates[0].pos, 1.0)
		end
		if stamina == -400 then
			audio_sample_play(BELLYSND4, gMarioStates[0].pos, 1.0)
		end
		if stamina == -60 then
			audio_sample_play(BURPSND2, gMarioStates[0].pos, 1.0)
		end
		if stamina <= 0 and stamina >= -400 then
			m.marioBodyState.eyeState = MARIO_EYES_HALF_CLOSED
		end
		if stamina <= -400 and stamina >= -600 then
			m.marioBodyState.eyeState = MARIO_EYES_LOOK_LEFT
		end
		if stamina <= -600 and stamina >= -800 then
			m.marioBodyState.eyeState = MARIO_EYES_LOOK_RIGHT
		end
	else
		stamina = 200
	end

	
	if m.action == ACT_STOMACH_SLIDE_STOP or m.action == ACT_BRAKING or m.action == ACT_STAR_DANCE_EXIT or m.action == ACT_SIDE_FLIP or m.action == ACT_SIDE_FLIP_LAND then
		m.marioBodyState.eyeState = MARIO_EYES_LOOK_RIGHT
	end
	
end

hook_event(HOOK_ON_MODS_LOADED, on_character_select_load)